<?php
require_once __DIR__ . '/../core/Controller.php';
require_once __DIR__ . '/../models/GctTranslationService.php';

class ApiController extends Controller
{
    public function translate()
    {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            return $this->json(['success' => false, 'error' => 'Metode tidak diizinkan. Gunakan POST.'], 405);
        }

        // ---- Same-origin check (Origin/Referer harus host yang sama) ----
        $host    = $_SERVER['HTTP_HOST'] ?? '';
        $origin  = $_SERVER['HTTP_ORIGIN']  ?? '';
        $referer = $_SERVER['HTTP_REFERER'] ?? '';
        $ok = true;
        if ($origin)  { $ok = (parse_url($origin,  PHP_URL_HOST) === $host); }
        elseif ($referer) { $ok = (parse_url($referer, PHP_URL_HOST) === $host); }
        if (!$ok) {
            return $this->json(['success' => false, 'error' => 'Asal permintaan tidak diizinkan.'], 403);
        }

        // ---- Rate limit sederhana per IP (60 dtk / 30 req) ----
        $ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
        $now = time(); $window = 60; $maxReq = 30;
        $bucketDir = sys_get_temp_dir() . DIRECTORY_SEPARATOR . 'translator_rate';
        @mkdir($bucketDir, 0777, true);
        $bucketFile = $bucketDir . DIRECTORY_SEPARATOR . md5($ip) . '.json';
        $state = ['ts'=>$now, 'cnt'=>0];
        if (is_file($bucketFile)) {
            $prev = json_decode(@file_get_contents($bucketFile), true) ?: $state;
            if (($now - ($prev['ts'] ?? 0)) < $window) {
                $state = ['ts'=>$prev['ts'], 'cnt'=>($prev['cnt'] ?? 0) + 1];
            } else {
                $state = ['ts'=>$now, 'cnt'=>1];
            }
        } else {
            $state = ['ts'=>$now, 'cnt'=>1];
        }
        @file_put_contents($bucketFile, json_encode($state));
        if ($state['cnt'] > $maxReq) {
            return $this->json(['success' => false, 'error' => 'Terlalu banyak permintaan. Coba lagi sebentar.'], 429);
        }

        // ---- Ambil input ----
        $input = json_decode(file_get_contents('php://input'), true);
        if (!is_array($input)) {
            return $this->json(['success' => false, 'error' => 'Payload JSON tidak valid.'], 400);
        }

        $text   = isset($input['text'])   ? trim((string)$input['text']) : '';
        $source = isset($input['source']) ? (string)$input['source']     : '';
        $target = isset($input['target']) ? (string)$input['target']     : '';

        if ($text === '') {
            return $this->json(['success' => false, 'error' => 'Teks tidak boleh kosong.'], 422);
        }

        $allowed = ['id','en'];
        if (!in_array($source, $allowed, true) || !in_array($target, $allowed, true) || $source === $target) {
            return $this->json(['success' => false, 'error' => 'Pasangan bahasa tidak valid.'], 422);
        }

        // ---- Batas karakter per request (tekan biaya) ----
        if (defined('MAX_CHARS_PER_REQUEST') && MAX_CHARS_PER_REQUEST > 0) {
            $len = function_exists('mb_strlen') ? mb_strlen($text, 'UTF-8') : strlen($text);
            if ($len > MAX_CHARS_PER_REQUEST) {
                return $this->json([
                    'success' => false,
                    'error'   => 'Teks terlalu panjang. Maksimal ' . (int)MAX_CHARS_PER_REQUEST . ' karakter per permintaan.'
                ], 422);
            }
        }

        // ---- Panggil Google ----
        try {
            $svc = new GctTranslationService(LT_ENDPOINT, LT_API_KEY);
            $translated = $svc->translate($text, $source, $target);
            return $this->json(['success' => true, 'translation' => (string)$translated], 200);
        } catch (Exception $e) {
            return $this->json(['success' => false, 'error' => $e->getMessage()], 502);
        }
    }
}
