<?php /* Halaman tunggal: UI biru modern + glassmorphism, ramah subfolder */ ?>
<main class="page">
  <header class="hero">
    <div class="logo" aria-hidden="true">🌊</div>
    <h1>Translator <span>Indonesia ↔ Inggris</span></h1>
    <p class="tagline">UI modern, ringan, responsif. Endpoint siap: <code>api/translate</code>.</p>
  </header>

  <section class="card" aria-label="Panel Terjemahan">
    <!-- Segmented control arah terjemahan -->
    <div class="segmented" role="radiogroup" aria-label="Arah Terjemahan">
      <input type="radio" name="dir" id="id-en" value="id-en" checked>
      <label for="id-en">Indonesia → English</label>

      <input type="radio" name="dir" id="en-id" value="en-id">
      <label for="en-id">English → Indonesia</label>

      <span class="segmented-bg" aria-hidden="true"></span>
    </div>

    <div class="grid">
      <!-- Panel input -->
      <div class="panel">
        <div class="panel-head">
          <span class="lang-badge" id="srcBadge">ID</span>
          <button id="clearInputBtn" class="btn btn-ghost sm" title="Bersihkan input">Bersihkan</button>
        </div>

        <label for="inputText" class="sr-only">Teks sumber</label>
        <textarea id="inputText" placeholder="Ketik atau tempel teks di sini..."></textarea>

        <div class="bar">
          <div class="hint">Pintasan: <kbd>Ctrl</kbd> + <kbd>Enter</kbd> untuk menerjemahkan</div>
          <div class="counter" id="charCounter">0</div>
        </div>
      </div>

      <!-- Panel output -->
      <div class="panel output">
        <div class="panel-head">
          <span class="lang-badge" id="tgtBadge">EN</span>
          <div class="output-toolbar">
            <button id="copyBtn" class="btn btn-ghost sm" title="Salin hasil">Salin</button>
          </div>
        </div>

        <div id="outputText" class="output-box" role="region" aria-live="polite" aria-label="Hasil terjemahan"></div>
      </div>
    </div>

    <!-- Aksi -->
    <div class="actions">
      <button id="translateBtn" class="btn btn-primary">
        <span class="btn-label">Terjemahkan</span>
        <span class="spinner" aria-hidden="true"></span>
      </button>

      <button id="swapBtn" class="btn btn-secondary" title="Tukar arah (⇄)" aria-label="Tukar arah terjemahan">
        ⇄ Tukar
      </button>
    </div>
  </section>

  <footer class="foot">
    <small>Ramah XAMPP/subfolder. Error & notifikasi ditampilkan dalam Bahasa Indonesia.</small>
  </footer>
</main>
