<?php
// BASE_PATH sudah didefinisikan di config/config.php
$baseHref = BASE_PATH;
?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Pastikan semua link aset/route relatif terhadap BASE_PATH -->
  <base href="<?php echo htmlspecialchars($baseHref, ENT_QUOTES); ?>">
  <title><?php echo isset($title) ? htmlspecialchars($title, ENT_QUOTES) : 'Translator'; ?></title>

  <!-- Style utama (tema biru modern + glassmorphism + responsif) -->
  <link rel="stylesheet" href="assets/css/style.css?v=<?php echo time(); ?>">
</head>
<body>
  <?php echo isset($content) ? $content : ''; ?>

  <!-- Toast notifikasi -->
  <div id="toast" class="toast" role="status" aria-live="polite" aria-atomic="true"></div>

  <!-- Script UI (fetch('api/translate'), Ctrl+Enter, spinner, toast, swap, copy) -->
  <script src="assets/js/app.js?v=<?php echo time(); ?>"></script>
</body>
</html>
