<?php
/**
 * Loader .env minimal (tanpa Composer):
 * - Mendukung baris "KEY=value", "export KEY=value", #komentar, ;komentar
 * - Nilai bisa pakai kutip "..." atau '...'
 * - Ekspansi ${VAR} sederhana dari ENV yang sudah ada
 * - Set ke putenv(), $_ENV, dan $_SERVER
 */
if (!function_exists('_env_load')) {
    function _env_load($file)
    {
        if (!is_file($file) || !is_readable($file)) return;

        $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        foreach ($lines as $line) {
            $line = trim($line);
            if ($line === '' || $line[0] === '#' || $line[0] === ';') continue;

            // Dukungan "export VAR=val"
            if (stripos($line, 'export ') === 0) {
                $line = trim(substr($line, 7));
            }

            // Pecah KEY=VALUE
            $eqPos = strpos($line, '=');
            if ($eqPos === false) continue;

            $key = trim(substr($line, 0, $eqPos));
            $val = trim(substr($line, $eqPos + 1));

            // Hilangkan kutip
            if ((strlen($val) >= 2) && (
                 ($val[0] === '"'  && substr($val, -1) === '"') ||
                 ($val[0] === "'"  && substr($val, -1) === "'")
            )) {
                $quote = $val[0];
                $val = substr($val, 1, -1);
                if ($quote === '"') {
                    // Unescape sederhana untuk double-quoted
                    $val = str_replace(
                        ['\\n', '\\r', '\\t', '\\"', '\\\\'],
                        ["\n",  "\r",  "\t",  '"',   '\\'],
                        $val
                    );
                }
                // single-quoted: ambil apa adanya
            }

            // Ekspansi ${VAR}
            $val = preg_replace_callback('/\$\{([A-Z0-9_]+)\}/i', function ($m) {
                $v = getenv($m[1]);
                return ($v !== false) ? $v : '';
            }, $val);

            // Set ENV (override biar konsisten lokal)
            putenv("$key=$val");
            $_ENV[$key]    = $val;
            $_SERVER[$key] = $val;
        }
    }
}
