<?php
// Muat .env (jika ada) sebelum config
$__env = __DIR__ . '/../.env';
if (is_file($__env)) {
    require_once __DIR__ . '/../config/env_loader.php';
    _env_load($__env);
}
// Front Controller
require_once __DIR__ . '/../config/config.php';

// Autoloader sederhana (tanpa Composer & tanpa namespace)
spl_autoload_register(function ($class) {
    $paths = [
        __DIR__ . '/../app/controllers/' . $class . '.php',
        __DIR__ . '/../app/core/'        . $class . '.php',
        __DIR__ . '/../app/models/'      . $class . '.php',
    ];
    foreach ($paths as $p) {
        if (file_exists($p)) { require_once $p; return; }
    }
});

// Hitung path relatif dari REQUEST_URI terhadap direktori script (ramah subfolder)
$uriPath   = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$scriptDir = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/'); // contoh: /translator-mvc/public
$path      = trim(substr($uriPath, strlen($scriptDir)), '/'); // '' atau 'api/translate'

// Inisialisasi router & daftar rute
$router = new Router();
$router->get('',  'HomeController@index');         // Halaman UI
$router->post('api/translate', 'ApiController@translate'); // Endpoint JSON

// Dispatch request
$router->dispatch($path, $_SERVER['REQUEST_METHOD']);
